#pragma once 


namespace Config
{
	namespace Game
	{
		extern int UserInput; 
		extern int CompleteMapInformation; 
		extern int GameSpeed; 
		extern bool UseThread;
	}
	namespace Protoss
	{
		extern double MineSpeed; 
	}
	namespace StrategyManager
	{
		extern int FrequencyFrame; 
		extern int SearchMaxDepth; 
		extern int MinAttackNum;
		extern int SearchFrequencyFrame; 
		extern int MinMineNum; 
		extern int StepOneMinerNum;
		extern int RegionCannonNum; 
		extern int GatewayNum; 
		extern int GatewayLatestTime; 
		extern int BaseLocationMinMineral; 
	}
	namespace InformationManager
	{
		extern int FrequencyFrame; 
		extern int GetNearBuildLength;     /* suggest 4, half sight range */
		const int LargeTileLength = 128; 
		extern int CannonEquivalentUnits; 
		extern int BaseLocationScoutFrame; 
		extern int ScoutLargeTileRange; 
		extern int RegionEnemyDefendRange; 
	}
	namespace BuildingManager
	{
		extern int FrequencyFrame; 
		extern int PlanBuildingWaitFrame; 
		extern int ConstructingEnemyRadius; 
		extern int BaseBuildRadius; 
		extern int BuildLocationSpace;
		extern int CannonGatherLimit;
		extern int CannonGatherRange;
	}
	namespace UnitProbeManager
	{
		extern int FrequencyFrame;
		extern int MapUnAnalyzeScoutNum; 
	}
	namespace UnitZealotManager
	{
		extern int FrequencyFrame;
		extern int WeaponSumRange;
		extern int GatherRange; 
		extern int SmallSizeAttackLimit; 
		extern int MediumSizeAttackLimit; 
		extern int LargeSizeAttackLimit; 
		extern int UnknownSizeAttackLimit; 
		extern int EnemyCoverRange; 
	}
	namespace UnitProbeInterface
	{
		extern int FrequencyFrame; 
		extern int BuilderCloseDistance; 
		extern int BuildNearMaxRange; 
		extern int BlockSpan; 
		extern int BlockRadius; 
		extern int EnemyReward; 
		extern int ObstacleReward;
		extern int UnWalkableReward; 
		extern int TargetReward; 
		extern int MineralReward; 
		extern int IterateTime; 
	}
	namespace UnitZealotInterface
	{
		extern int FrequencyFrame;
	}
	namespace Debug
	{
		extern bool DrawAttack; 
		extern bool DrawMove; 
		extern bool DrawRightClick; 
		extern bool DrawAttackTarget; 
		extern bool DrawBlocksRewards; 
		extern bool DrawPlanBuilding; 
		extern bool DrawSearchBuild; 
		extern bool DrawTime; 
		extern bool DrawExtendedInterface; 
	}
	namespace Timer
	{
		extern double TotalMicroSec; 
		extern double InformationManagerMaxMicroSec; 
		extern double StrategyManagerMaxMicroSec;
		extern double BuildingManagerMaxMicroSec;
		extern double UnitProbeInterfaceMaxMicroSec;
	}
}